<?php
/**
 * PeriodoDao.php
 * Modelo para la persistencia de datos de periodos de evaluación
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'Periodo.php';

class PeriodoDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function guardar(Periodo $p)
    {
        $sql = "INSERT INTO `periodo_evaluacion` (`Inicio`, `Fin`, `Status`) VALUES (?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $p->__get('_fechaInicio'), PDO::PARAM_STR);
        $stmt->bindValue(2, $p->__get('_fechaFin'), PDO::PARAM_STR);
        $stmt->bindValue(3, $p->__get('_status'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idPeriodo'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al generar el periodo de evaluación. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerUltimoPeriodo()
    {
        $sql = "SELECT * FROM `periodo_evaluacion` ORDER BY `Id_Periodo` DESC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['periodo'] = $stmt->fetch(PDO::FETCH_OBJ);
            $response['hayPeriodo'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el último periodo de evaluación. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function periodoActivo($fechaInicio, $fechaFin)
    {
        $sql = "SELECT * FROM `periodo_evaluacion` WHERE `Inicio` >= ? AND `Fin` <= ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaFin, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['hayPeriodo'] = $stmt->rowCount();
            $response['periodo'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                    . 'del periodo a evaluar. ' . TICKETS;
        }
        
        return $response;
    }
}